/*
          
T3Series.mqh 
PriceSeries.mqh 
  (): MetaTrader\experts\include\
Heiken Ashi#.mq4
  (): MetaTrader\indicators\
*/
//+------------------------------------------------------------------+ 
//|                                                    T3.Taotra.mq4 | 
//|                        Copyright  2006,        Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2006, Nikolay Kositsin"
#property link "farria@mail.redcom.ru" 
//----     
#property indicator_separate_window
//----   
#property indicator_buffers 6
//----  
#property indicator_color1 Yellow
#property indicator_color2 Red
#property indicator_color3 Magenta
#property indicator_color4 Aqua
#property indicator_color5 LimeGreen
#property indicator_color6 Blue
//----    --------------------------------------------------------------------------------------------------+
extern int MA_Period_1 = 3; //   1
extern int MA_Period_2 = 5; //   2
extern int MA_Period_3 = 8; //   3
extern int MA_Period_4 = 12;//   4
extern int MA_Period_5 = 21;//   5
extern int MA_Period_6 = 34;//   6
extern int Smooth_Curvature = 100;
extern int Shift1 = 0;  // c  1    
extern int Shift2 = 0;  // c  2   
extern int Shift3 = 0;  // c  3   
extern int Shift4 = 0;  // c  6   
extern int Shift5 = 0;  // c  5   
extern int Shift6 = 0;  // c  6   
extern int  Input_Price_Customs = 0;  // ,      
//(0-CLOSE, 1-OPEN, 2-HIGH, 3-LOW, 4-MEDIAN, 5-TYPICAL, 6-WEIGHTED, 7-Heiken Ashi Close, 8-SIMPL, 9-TRENDFOLLOW, 10-0.5*TRENDFOLLOW,
//11-Heiken Ashi High, 12-Heiken Ashi Low, 13-Heiken Ashi Open, 14-Heiken Ashi Close.)
//---- -------------------------------------------------------------------------------------------------------------------------------+
//----  
double Ind_Buffer1[];
double Ind_Buffer2[];
double Ind_Buffer3[];
double Ind_Buffer4[];
double Ind_Buffer5[];
double Ind_Buffer6[];
//+------------------------------------------------------------------+ 
//----+   T3Series 
//----+   T3SeriesResize 
//----+   T3SeriesAlert 
//----+   T3_ErrDescr  
#include <T3Series.mqh> 
//+------------------------------------------------------------------+ 
//----+   PriceSeries
//----+   PriceSeriesAlert 
#include <PriceSeries.mqh>
//+------------------------------------------------------------------+  
//| T3.Taotra initialization function                                |
//+------------------------------------------------------------------+ 
int init()
  {
//----    
   SetIndexStyle(0, DRAW_LINE);
   SetIndexStyle(1, DRAW_LINE);
   SetIndexStyle(2, DRAW_LINE);
   SetIndexStyle(3, DRAW_LINE);
   SetIndexStyle(4, DRAW_LINE);
   SetIndexStyle(5, DRAW_LINE);
//----
   IndicatorDigits(Digits);
//----        
   IndicatorShortName("T3 Taotra");
//----   ,       
   SetIndexDrawBegin(0, 100);
   SetIndexDrawBegin(1, 100);
   SetIndexDrawBegin(2, 100);
   SetIndexDrawBegin(3, 100);
   SetIndexDrawBegin(4, 100);
   SetIndexDrawBegin(5, 100);
//---- 6     
   SetIndexBuffer(0, Ind_Buffer1);
   SetIndexBuffer(1, Ind_Buffer2);
   SetIndexBuffer(2, Ind_Buffer3);
   SetIndexBuffer(3, Ind_Buffer4);
   SetIndexBuffer(4, Ind_Buffer5);
   SetIndexBuffer(5, Ind_Buffer6);
//----      
   SetIndexShift (0, Shift1); 
   SetIndexShift (1, Shift2); 
   SetIndexShift (2, Shift3); 
   SetIndexShift (3, Shift4); 
   SetIndexShift (4, Shift5); 
   SetIndexShift (5, Shift6); 
//----   ,      
   SetIndexEmptyValue(0,0);
   SetIndexEmptyValue(1,0);
   SetIndexEmptyValue(2,0);
   SetIndexEmptyValue(3,0);
   SetIndexEmptyValue(4,0);
   SetIndexEmptyValue(5,0);
   SetIndexEmptyValue(6,0);
//----       
   T3SeriesAlert(0,"MA_Period_1",MA_Period_1);
   T3SeriesAlert(0,"MA_Period_2",MA_Period_2);
   T3SeriesAlert(0,"MA_Period_3",MA_Period_3);
   T3SeriesAlert(0,"MA_Period_4",MA_Period_4);
   T3SeriesAlert(0,"MA_Period_5",MA_Period_5);
   T3SeriesAlert(0,"MA_Period_6",MA_Period_6);
   PriceSeriesAlert(Input_Price_Customs);
//----+      T3Series, nT3.number=7(    T3Series)
  if (T3SeriesResize(6)!=6)return(-1);
//----  
   return(0);
  }
//+------------------------------------------------------------------+ 
//| T3.Taotra iteration function                                     |
//+------------------------------------------------------------------+ 
int start()
  {
//----       
if(Bars-1<=MA_Period_1) return(0);
//----
double Resalt,Price; 
//----+        
int limit,reset,MaxBar,bar,counted_bars=IndicatorCounted();
//----    
if (counted_bars<0)return(-1);
//----       
//---- (    counted_bars  T3Series   !!!)
if (counted_bars>0) counted_bars--;
//----     ,        
MaxBar=Bars-1;
//----     ,        
limit = MaxBar - counted_bars;
   
for(bar=limit;bar>=0;bar--)
{
   Price=PriceSeries(Input_Price_Customs,bar);
   //----+ ----------------------------------------------------------------------------------------+      
   //----+      T3Series   0, 1, 2, 3, 4, 5.
   //----+  nT3.Length  t    (nT3.din=0)
   //----+ ----------------------------------------------------------------------------------------+ 
   Resalt=T3Series(0,0,MaxBar,limit,Smooth_Curvature,MA_Period_1 ,Price,bar,reset);
   //----+       
   if(reset!=0)return(-1);
   Ind_Buffer1[bar]=Resalt; 
   //----+ ----------------------------------------------------------------------------------------+       
   Resalt=T3Series(1,0,MaxBar,limit,Smooth_Curvature,MA_Period_2 ,Price,bar,reset);
   //----+       
   if(reset!=0)return(-1);
   Ind_Buffer2[bar]=Resalt; 
   //----+ ----------------------------------------------------------------------------------------+ 
   Resalt=T3Series(2,0,MaxBar,limit,Smooth_Curvature,MA_Period_3 ,Price,bar,reset);
   //----+       
   if(reset!=0)return(-1);
   Ind_Buffer3[bar]=Resalt; 
   //----+ ----------------------------------------------------------------------------------------+ 
   Resalt=T3Series(3,0,MaxBar,limit,Smooth_Curvature,MA_Period_4 ,Price,bar,reset);
   //----+       
   if(reset!=0)return(-1); 
   Ind_Buffer4[bar]=Resalt;   
   //----+ ----------------------------------------------------------------------------------------+ 
   Resalt=T3Series(4,0,MaxBar,limit,Smooth_Curvature,MA_Period_5 ,Price,bar,reset);
   //----+       
   if(reset!=0)return(-1); 
   Ind_Buffer5[bar]=Resalt; 
   //----+ ----------------------------------------------------------------------------------------+ 
   Resalt=T3Series(5,0,MaxBar,limit,Smooth_Curvature,MA_Period_6,Price,bar,reset);
   //----+       
   if(reset!=0)return(-1); 
   Ind_Buffer6[bar]=Resalt;   
   //----+ ----------------------------------------------------------------------------------------+ 
}
//----
   return(0);
  }
//+------------------------------------------------------------------------------+


